const apiURL = "./api/names-api.php"
//alert("working...")

// For frontend, first we decide on what the 'state' will be,
// in other words, what will change? : STATE
let state = {
    names : ["ali", "özge"]
};

// We want to connect the ol to our state : RENDERING
// e.g when state changes, UI changes
function render() {
    $("#namelist").html(""); // Reset content
    for (let name of state.names) {
        $("#namelist").append(`
            <li>
                <span>${name}</span>
                <i class="fa fa-trash-can"></i>
            </li>
        `)
    }
}

// Another rendering function, also could be implemented in state
// but we do not want to render the list again when rendering the 
// loading gif. That's why we separate
function showLoading(flag) {
    if (flag) 
        $("#loading").show();
    else 
        $("#loading").hide();
}

// STATE MANAGEMENT
function setList(newList) {
    state.names = newList;
    render();
}

function addToList(name) {
    state.names.push(name);
    render();
}

function deleteFromList(name) {
    let pos = state.names.indexOf(name);
    state.names.splice(pos, 1);
    render();
}

// ENTRY POINT
function initApp() {
    $.get(apiURL, function(response) {
        setList(response);
        showLoading(false);
    })
}
initApp();

// EVENT HANDLERS
$("#namebox").on("change", function() {
    let name = $(this).val();
    showLoading(true);
    $(this).val("");
    $.ajax({
        type: "POST",
        url: apiURL,
        data: JSON.stringify({"name" : name}),
        contentType: "application/json",
        success : function(response) {
            showLoading(false);
            addToList(name);
        }
    })
})

$("#namelist").on("click", "i.fa-trash-can", function(){
    let name = $(this).prev().text();
    showLoading(true);
    $.ajax({
        type: "DELETE",
        url: apiURL,
        data: JSON.stringify({"name" : name}),
        contentType: "application/json",
        success : function(response) {
            showLoading(false);
            deleteFromList(response.name);
        }
    })
})