<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket Form</title>
    <style>
        table { 
            border-collapse: collapse;
            margin: 40px auto;
        }

        td {
            padding: 7px; border: 1px solid #666;
        }

        .error {
            background: #FDD;
        }

        .error_msg {
            font-style: italic;
            text-align: center;
            color: red;
        }
    </style>         
</head>
<body>
    <form action="" method = "post">
        <table>
            <tr>
                <td>Singer: </td>
                <td>
                    <select name="singer">
                    <option value="0" 
                    <?= isset($out["form"]["singer"]) && $out["form"]["singer"] == "0" ? "selected" : "" ?>
                    >Teoman</option>
                    <option value="1"
                    <?= isset($out["form"]["singer"]) && $out["form"]["singer"] == "1" ? "selected" : "" ?>
                    >Mor ve Ötesi</option>
                    <option value="2"
                    <?= isset($out["form"]["singer"]) && $out["form"]["singer"] == "2" ? "selected" : "" ?>
                    >Feridun Düzağaç</option>
                    </select>
                </td>
            </tr>
            <tr>
                <td>VIP: </td>
                <td>
                    <input type="checkbox" name="vip",
                    <?= isset($out["form"]["vip"]) ? "checked" : "" ?>
                    >
                </td>
            </tr>
            <tr <?= isset($out["error"]["person"]) ? "class = 'error'" : ""?>> 
                <td>Person Amount: </td>
                <td><input type="text" name="number" size="2"
                value="<?= isset($out["form"]["number"]) ? filter_var($out["form"]["number"], FILTER_SANITIZE_SPECIAL_CHARS) : "1" ?>"
                >
            </td>
            </tr>
            <tr>
                <td colspan = "2">
                    <button type = "submit">RESERVE</button>
                </td>
            </tr>
        </table>
    </form>

    <?php if (isset($out["error"])) : ?>
            <?php foreach($out["error"] as $e) : ?>
                <p class="error_msg"><?= $e ?></p>
            <?php endforeach ?>
    <?php endif ?>
</body>
</html>