<?php
  if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // backend
    extract($_POST); // $singer, [$vip], $number

    // 1. Input Validation
    $error = [];
    // check number of person
    if (filter_var($number, FILTER_VALIDATE_INT) === false) {
        $error["person"] = "Not an integer value";
    } else if ($number < 1 || $number > 6) {
        $error["person"] = "Not in the range of [1 to 6]";
    }

    // validate singer
    if (!isset($singer) || !in_array($singer, ["0", "1", "2"])) {
        $error["singer"] = "Not valid singer";
    }

    $out = ["error" => $error, "form" => $_POST];

    // 2. Processing (Business Logic)
    if (empty($error))  {
        // Validated
        $base = [75, 35, 50];
        $names = ["Teoman", "Mor ve Ötesi", "Feridun Düzağaç"];
        $price = $base[$singer] * $number;
        $price *= isset($vip) ? 2 : 1;

        $out["singer"] = $names[$singer];
        $out["vip"] = isset($vip) ? "YES" : "NO";
        $out["price"] = $price;
        $out["number"] = $number;
        
        $qs = "singer=$singer&number=$number";
        $qs .= isset($vip) ? "&vip=on" : "";
        $out["qs"] = $qs;

        // frontend - output
        require "./app_output_view.php";
    } else {
        // there is an error
        require "./form.php";
    }

  } else {
    // frontend - input
    $out = ["form" => $_GET];
    require "./form.php";
  }